#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.IO;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.UnitTests
{

	/// <summary>
	/// Summary description for BaseTest.
	/// </summary>
	public class BaseTest
	{
		private bool _refreshData = true;
        //***********************************************************************************************************
        //*
        //*              ATTENTION DEVELOPER  -- IF DEBUGGING UNITTESTS - 
        //*     YOU MAY GET A TYPE INITIALIZER FAILURE ON THE BASETEST CLASS IF THIS ISN'T SET PROPERLY--
        //*
        //*MAKE SURE YOU UPDATE THE configuration.xml FILE, IN THE UNITTEST PROJECT FOLDER
        //*            <database>
        //*                 <serverName>r05ishvnnvbe2t1</serverName>        THIS SHOULD BE THE 10.3.7.170 vnn
        //*                 <databaseName>UNITTEST_VBECS_V2101</databaseName>       <-- UPDATE THIS
        //*             </database>
        //*
        //*     I'LL AUTOMATE THIS EVENTUALLY..............
        //***********************************************************************************************************
		private static bool _isAutoBuild = UnitTestConfig.IsAutoBuild;
		//private static string BACKUP_PATIENT_TABLE = "BackupPatient";
		private static string _action = "Initial";

		/// <summary>
		/// We want the data to get reset ONCE, when the first unit test is run.
		/// Since all UnitTest clases are SUPPOSED to inherit from this BaseTest class
		/// We're going to reset it here (AutoBuild seems to run randomly, as far as which classes/tests run first)
		/// DOH!! NOTE!!!  This Constructor runs BEFORE the user clicks RUN, not sure what happens during autobuild.
		/// </summary>
		public BaseTest()
		{
			if (_isAutoBuild)
			{
				_isAutoBuild = false;
                //Update the database too so future debug runs dont affect it
			    UnitTestUtil.RunSQL("UPDATE VbecsGlobalConfig set ParameterValue = 'False' WHERE ParameterName = 'IsAutoBuild'");

//					//Removes all USER data and MIRROR data
//					UnitTestUtil.RunSQL("exec utilsp_ClearDatabaseForPackaging");
//					UnitTestUtil.RunSQL("exec utilsp_InsertCustomErrorMessages 0");

					this.SetupMinimalData();
				//}
			}
		}

		/// <summary>
		/// Adds required data to a blank database
		/// </summary>
		private void SetupMinimalData()
		{
			try
			{
				//**************************************************************************************************
				//1. The Data wipe clears out the VistaLinkControl table, repopulate using app.config values and init
				//**************************************************************************************************
				_action = "ResetVistaLinkControlTable";
				DataCreator.ResetVistaLinkControlTable();

				_action = "Refresh InterfaceControl Table";
				DataCreator.RefreshInterfaceControlTable();

                //WORKAROUND PUT IN ON 2/18/2014 - LOHSE - FOR VistaLink because the rules are boken and VistALinkConfig has not been coded
                //REMOVE THIS AFTER CARL ADDS IN THIS CODE
			    UnitTestUtil.RunSQL("UPDATE BrokenRuleSet SET IsInitiallyBroken = 0 WHERE FormName = 'VistALinkConfig' AND FieldName LIKE 'Vbecs%'");

				//**************************************************************************************************
				//2. Create our test Division
				//**************************************************************************************************
				//Get the list of divisions from VistA
				_action = "GetDivisionDefListFromVistA";
				VistALinkUnitTestHarness.RequireConnection();
				System.Collections.ICollection _availableVistADivisions = BOL.DivisionDefinition.GetDivisionDefListFromVistA();

				//To create a new division, we use the VistA division as a template
				foreach (BOL.DivisionDefinition vistaDiv in _availableVistADivisions)
				{
					if (vistaDiv.DivisionCode.Trim() == this.TestDivisionCode.Trim())
					{
						BOL.DivisionBase testDivision = new BOL.DivisionBase(vistaDiv);
						testDivision.UsesLabelPrinter = false;
						testDivision.FacilityGuid = DataCreator.GetRandomRecordGuid(TABLES.Facility.TableName, "IccbbaRegistrationNumber IS NOT NULL");
						testDivision.TimeZoneConfig = new BOL.TimeZoneConfig();
						testDivision.TimeZoneConfig.TimeZone = new BOL.TimeZone('S');
						testDivision.TimeZoneConfig.DaylightSavingsType = Common.DaylightSavingsType.UsaStandard;
						testDivision.LockInactivityTimeoutMin = 5;
						testDivision.AccessionAreaId = 29;		//This is cheating - TODO: Code the VistA RPC call lookup
						testDivision.PrinterName = "VBECS Printer";	//This is also cheating - TODO: Code routine to parse Printers array
						testDivision.IsActive = true;

						//this is total crap, but the division won't save unless you set the common.logonuser
						Common.LogonUser.LogonUserDivisionCode = testDivision.DivisionCode;
						testDivision.PersistDivisionBase(Common.UpdateFunction.UnitTests);
						break;
					}
				}
				UnitTestUtil.RunSQL("UPDATE VamcDivision SET MedicalDirectorName = 'BigSalad'");

				//**************************************************************************************************
				//3. Create the TestUser (aka, me!) -- See TestUser property
				//**************************************************************************************************
				_action = "Create myself";
				BOL.VbecsUser myself = new BOL.VbecsUser();	//To add a new user, you MUST use the blank constructor - weak!
			    myself.UserNTLoginID = "VHAISHLOHSEG0";
				myself.UserDuz = "53311";
				myself.UserInitials = "NDY";
				myself.UserName = "Greg Lohse";
				myself.VistAUserName = "Lohse, Greg";
				
				BOL.VbecsUserDivisionRole myRole = new BOL.VbecsUserDivisionRole(new BOL.Division(this.TestDivisionCode));
				myRole.Role = new BOL.UserRole(Common.UserRoleType.AdministratorSupervisor);
				myRole.IsActive = true;
				myself.DivisionsAndRoles.Add(myRole);

				myself.Persist(Common.UpdateFunction.UnitTests);
				VistALinkUnitTestHarness.ReleaseConnection();

				//**************************************************************************************************
				//3. Create the TechUser - some tests are based on security rights
				//**************************************************************************************************
				_action = "Create Vbecs1";
				BOL.VbecsUser techie = new BOL.VbecsUser();	//To add a new user, you MUST use the blank constructor - weak!
				techie.UserNTLoginID = "VHAISHVBECS1";
				techie.UserDuz = "53333";
				techie.UserInitials = "TU1";
				techie.UserName = "User One";
				techie.VistAUserName = "User,One";
				
				BOL.VbecsUserDivisionRole techRole = new BOL.VbecsUserDivisionRole(new BOL.Division(this.TestDivisionCode));
				techRole.Role = new BOL.UserRole(Common.UserRoleType.Technologist);
				techRole.IsActive = true;
				techie.DivisionsAndRoles.Add(techRole);

				techie.Persist(Common.UpdateFunction.UnitTests);

				//**************************************************************************************************
				//4. Create some other guys -- make this more efficient later
				//**************************************************************************************************
				_action = "Create Krz";
				BOL.VbecsUser kman = new BOL.VbecsUser();	//To add a new user, you MUST use the blank constructor - weak!
				kman.UserNTLoginID = "VHAISHDOBRAK";
				kman.UserDuz = "53304";
				kman.UserInitials = "DK1";
				kman.UserName = "Krzysztof Dobranowski";
				kman.VistAUserName = "DOBRANOWSKI,KRZYSZTOF";
				
				BOL.VbecsUserDivisionRole kmanRole = new BOL.VbecsUserDivisionRole(new BOL.Division(this.TestDivisionCode));
				kmanRole.Role = new BOL.UserRole(Common.UserRoleType.AdministratorSupervisor);
				kmanRole.IsActive = true;
				kman.DivisionsAndRoles.Add(kmanRole);

				kman.Persist(Common.UpdateFunction.UnitTests);

                _action = "Create VHAISHVBECS2";
				BOL.VbecsUser askew = new BOL.VbecsUser();	//To add a new user, you MUST use the blank constructor - weak!
                askew.UserNTLoginID = "VHAISHVBECS2";
                askew.UserDuz = "53334";
				askew.UserInitials = "TU2";
                askew.UserName = "Test User2";
                askew.VistAUserName = "USER,TWO";
				
				BOL.VbecsUserDivisionRole askewRole = new BOL.VbecsUserDivisionRole(new BOL.Division(this.TestDivisionCode));
				askewRole.Role = new BOL.UserRole(Common.UserRoleType.Technologist);
				askewRole.IsActive = true;
				askew.DivisionsAndRoles.Add(askewRole);

				askew.Persist(Common.UpdateFunction.UnitTests);

				_action = "Create Jensen";
				BOL.VbecsUser jensen = new BOL.VbecsUser();	//To add a new user, you MUST use the blank constructor - weak!
				jensen.UserNTLoginID = "VHAISHJENSEC0";
				jensen.UserDuz = "53325";
				jensen.UserInitials = "CJ1";
				jensen.UserName = "Carl Jensen";
				jensen.VistAUserName = "JENSEN,CARL";
				
				BOL.VbecsUserDivisionRole jensenRole = new BOL.VbecsUserDivisionRole(new BOL.Division(this.TestDivisionCode));
				jensenRole.Role = new BOL.UserRole(Common.UserRoleType.AdministratorSupervisor);
				jensenRole.IsActive = true;
				jensen.DivisionsAndRoles.Add(jensenRole);

				jensen.Persist(Common.UpdateFunction.UnitTests);

				_action = "Create Stedum";
				BOL.VbecsUser stedum = new BOL.VbecsUser();	//To add a new user, you MUST use the blank constructor - weak!
				stedum.UserNTLoginID = "VHAISHVANSTC0";
				stedum.UserDuz = "53322";
				stedum.UserInitials = "CVS";
				stedum.UserName = "Carrie Van Stedum";
				stedum.VistAUserName = "VANSTEDUM,CARRIE";
				
				BOL.VbecsUserDivisionRole stedumRole = new BOL.VbecsUserDivisionRole(new BOL.Division(this.TestDivisionCode));
				stedumRole.Role = new BOL.UserRole(Common.UserRoleType.AdministratorSupervisor);
				stedumRole.IsActive = true;
				stedum.DivisionsAndRoles.Add(stedumRole);

				stedum.Persist(Common.UpdateFunction.UnitTests);
				//**************************************************************************************************
				//6. Refresh the VistACache data
				//**************************************************************************************************
				VistALinkUnitTestHarness.RequireConnection();
				_action = "UpdateCache";
				DAL.VAL.VistaCache.UpdateCache(5);		//Put the cache data in
				VistALinkUnitTestHarness.ReleaseConnection();

				//**************************************************************************************************
				//7. Create a junker Division
				//**************************************************************************************************
				//To create a new division, we use the VistA division as a template
				_action = "Create Junk Division";
				foreach (BOL.DivisionDefinition vistaDiv in _availableVistADivisions)
				{
					if (vistaDiv.DivisionCode.Trim() != this.TestDivisionCode.Trim())
					{
						BOL.DivisionBase junkDivision = new BOL.DivisionBase(vistaDiv);
						junkDivision.UsesLabelPrinter = false;
						junkDivision.FacilityGuid = DataCreator.GetRandomRecordGuid(TABLES.Facility.TableName, "IccbbaRegistrationNumber IS NOT NULL");
						junkDivision.TimeZoneConfig = new BOL.TimeZoneConfig();
						junkDivision.TimeZoneConfig.TimeZone = new BOL.TimeZone('S');
						junkDivision.TimeZoneConfig.DaylightSavingsType = Common.DaylightSavingsType.UsaStandard;
						junkDivision.LockInactivityTimeoutMin = 5;
						junkDivision.AccessionAreaId = 29;		//This is cheating - TODO: Code the VistA RPC call lookup
						junkDivision.PrinterName = "VBECS Printer";	//This is also cheating - TODO: Code routine to parse Printers array
						junkDivision.IsActive = true;

						//this is total crap, but the division won't save unless you set the common.logonuser
						Common.LogonUser.LogonUserDivisionCode = junkDivision.DivisionCode;
						junkDivision.PersistDivisionBase(Common.UpdateFunction.UnitTests);
						break;
					}
				}

				Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;		//Set it back
			}
			catch(Exception err)
			{
				_isAutoBuild = false;		//reset the flag so we can try to setup the data again
				Console.WriteLine("***********************UNIT TEST ERROR - BaseTest***************************");
				Console.WriteLine("***Action:***" + _action + "*************************");
				Console.WriteLine(err.Message);
			    Console.WriteLine(@"file://" + Path.Combine(Environment.CurrentDirectory ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFile")));
			    Console.WriteLine("DBCONSTRING=" + COMMON.VbecsConfig.Current.PrimaryDbConnectionString);
				Console.WriteLine("****************************************************************************");
				throw err;
			}
		}


		/// <summary>
		/// Add at will!
		/// </summary>
		/// <returns></returns>
		private string GetRandomFakeDiagnosis()
		{
			int randNum = new Random().Next(1,5);

			if (randNum == 1) return("Patient has lazy eye, stare at forehead");
			if (randNum == 2) return("Patient has the dropsies, keep mop handy");
			if (randNum == 3) return("Patient lost legs while urinating in ocean");
			if (randNum == 4) return("Patient's momma makes good pie but has a hair lip");
			if (randNum == 5) return("Patient always smells like pickles");

			return("Patient's butt leaks");

		}

		/// <summary>
		/// Data needs to be retrieved from database
		/// </summary>
		public bool RefreshData
		{
			get
			{
				return(this._refreshData);
			}
			set
			{
				this._refreshData = value;
			}
		}

		/// <summary>
		/// Shortcut to save on typing
		/// </summary>
		public string TestDivisionCode
		{
			get
			{
				return(UnitTestConfig.TestDivisionCode);
			}
		}

		/// <summary>
		/// This will be me
		/// </summary>
		public BOL.VbecsUser TestUser
		{
			get
			{
				//I create a new one everytime in case a test is wanting to see changes
				return (new BOL.VbecsUser(Environment.UserName));
			}
		}

		/// <summary>
		/// This will be a tech user
		/// </summary>
		public BOL.VbecsUser TechUser
		{
			get
			{
				//This is our tech user
				return (new BOL.VbecsUser("VHAISHVBECS2"));
			}
		}

		protected void BaseSetUp()
		{
			Common.LogonUser.LogonUserDUZ = "53311";
			if (Common.LogonUser.LogonUserDivisionCode != UnitTestConfig.TestDivisionCode)
			{
				Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;
			}
		}						 
	}
}
#endif